//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.10 page 60
//Topic:A copper pipe carries liquid oxygen
//==============================================================================

model Ex2_10
extends Modelica.Constants;

//========================
//parameter section

parameter Real r1(unit = "m")=0.03"Inner radius of copper pipe";
parameter Real r2(unit = "m")=0.035"Outer radius of copper pipe";
parameter Real T1(unit = "degree celcius")=-182"Temperature of liquid oxygen";
parameter Real Ta(unit = "degree celcius")=20"Ambient temperature";
parameter Real T3(unit = "degree celcius")=10"Due point temperature";
parameter Real k(unit = "W/mK")=0.02"Thermal conductivity of insulation";
parameter Real h(unit = "W/m^2K")=17"convective heat transfer coefficient";
parameter Real kc(unit = "W/mK")=400"Thermal conductivity of copper";
parameter Real L(unit = "m")=1"Assuming length of the copper pipe as 1m";

//========================
//Variable section

Real R1(unit = "K/W")"Conduction resistance of copper pipe";
Real R2(unit = "K/W")"Conduction resistance of insulating material";
Real R3(unit = "K/W")"Convective resistance at the outer surface";
Real r3(unit = "m")"Outer radius of insulation";
Real L3(unit = "m")"Thickness of insulation";

//=========================
//Equation section

equation
R1=(log(r2/r1))/(2*3.14*L*kc);
R2=(log(r3/r2))/(2*3.14*L*k);
R3=1/(2*3.14*L*h*r3);
r3*log(r3)+(r3*3.35)=0.023;
L3=r3-r2;
end Ex2_10;
