//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.11 page 63
//Topic:Cylinders with generation of thermal energy
//================================================================================

package Ex2_11

//================================================================================

model Ex2_11_a
extends Modelica.Constants;

//==================================
//parameter section

parameter Real V(unit="V")=25"Voltage drop in the wire";
parameter Real I(unit="A")=40"Current flow across wire";
parameter Real d(unit="mm")=2.5"Diameter of the wire";
parameter Real L(unit="m")=0.5"Length of the wire";
parameter Real k(unit="W/mK")=24"Thermal conductivity of the wire material";
parameter Real Tw(unit="K")=650"Surface temperature";

//==================================
//Variable section

Real qG(unit="W/m^3")"Rate of generation of thermal energy per unit volume";


//==================================
//Equation section 

equation
qG=(V*I*4*10^6)/(pi*(d^2)*L);


end Ex2_11_a;

//================================================================================

model Ex2_11_b
extends Ex2_11_a;

//===================================
//Variable section

Real To(unit="K")"The maximum temperature in the wire";

//===================================
//Equation section

equation

To=Tw+((qG*(d^2))/(4*k*10^6));

end Ex2_11_b;
//==================================================================================

end Ex2_11;
