//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.12 page 66
//Topic:Spheres with generation of thermal energy
//================================================================================

package Ex2_12

//================================================================================

model Ex2_12_a
extends Modelica.Constants;

//===============================
//parameter section

parameter Real di(unit="m")=5"Internal diameter of the tank";
parameter Real th(unit="mm")=25"Thickness of the tank";
parameter Real k(unit="W/mK")=15"Thermal conductivity of the stainless steel";
parameter Real hi(unit="W/m^2K")=80"Heat transfer coefficient at inner surface";
parameter Real ho(unit="W/m^2K")=10"Heat transfer coefficient at outer surface";
parameter Real To(unit="degree celcius")=20"Ambient temperature";
parameter Real Ti(unit="degree celcius")=0"Inner temperature";
parameter Real T2(unit="degree celcius")=4"Assumed outer surface temperature";
parameter Real dhf(unit="kJ/kg")=334"Heat of fusion";
parameter Real t(unit="hours")=24"Heat transfer during a day";

//================================
//Variable section

Real do(unit="m")"Outer diameter";
Real A1(unit="m^2")"Inner surface area of the tank";
Real A2(unit="m^2")"outer surface area of the tank";
Real Ri(unit="K/W")"Convective resistance at inner surface";
Real Rs(unit="K/W")"Conduction resistance of the tank";
Real Roc(unit="K/W")"Convective resistance at the outer surface";
Real Ror(unit="K/W")"Radiative resistance at the outer surface";
Real hr(unit="W/m^2K")"Radiative heat transfer coefficient";
Real Ro(unit="K/W")"Equvivalent resistance";
Real Rt(unit="K/W")"Total resistance";
Real Q(unit="W")"The rate of heat transfer";
Real T2n(unit="degree celcius")"Outer surface temperature";

//==================================
//Equation section

equation
do=di+(2*th/1000);
A1=pi*(di^2);
A2=pi*(do^2);
Ri=1/(hi*A1);
Rs=(do-di)/(2*pi*k*do*di);
Roc=1/(ho*A2);
hr=sigma*(((T2+273.15)^2)+((To+273.15)^2))*(T2+273.15+(To+273.15));
Ror=1/(hr*A2);
(1/Ro)=(1/Roc)+(1/Ror);
Rt=Ri+Rs+Ro;
Q=(To-Ti)/Rt;
T2n=To-(Q*Ro);

end Ex2_12_a;

//================================================================================

model Ex2_12_b
extends Ex2_12_a;

//================================
//Variable section

Real mi(unit="kg")"Amount of ice melting for a day"; 

//================================
//Equation section

equation

mi=(20*t*3600)/(dhf);

end Ex2_12_b;


//================================================================================

end Ex2_12;
