//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.2 page 43
//Topic:A laboratory furnace wall
//==============================================================================

model Ex2_2

//========================
//Parameter section

parameter Real Q(unit = "W/m^2")=900"Heat transfer rate through wall of surface";
parameter Real Lf(unit = "m")=0.2"Thickness of fire clay bricks";
parameter Real kf(unit = "W/mK")=1"Thermal conductivity of fire clay brick";
parameter Real ki(unit = "W/mK")=0.07"Thermal conductivity of insulating material";
parameter Real Ti(unit = "K")=1250"Inner temperature of brick surface";
parameter Real To(unit = "K")=310"Outer temperature of insulating material";

//=========================
//Variable section

Real L(unit = "m")"Thickness of insulating material";

//=========================
//Equation section

equation
L=(((Ti-To)/Q)-(Lf/kf))*ki;
end Ex2_2;

//====================================
