//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 3:Multidimensional Steady-State Heat Conduction
//Example :3.3 page 112
//Topic:Solution of nodal equation
//===================================================================================

model Ex3_3

//==================================
//Parameter section

parameter Real h(unit="W/m^2K")=10"Convective heat transfer coefficient";
parameter Real k(unit="W/mK")=2.5"Thermal conductivity of the plate";

//==================================
//Variable section

Real T1(unit="K")"Temperature at nodal point 1";
Real T2(unit="K")"Temperature at nodal point 2";
Real T3(unit="K")"Temperature at nodal point 3";
Real T4(unit="K")"Temperature at nodal point 4";
Real T5(unit="K")"Temperature at nodal point 5";
Real T6(unit="K")"Temperature at nodal point 6";
Real T7(unit="K")"Temperature at nodal point 7";
Real T8(unit="K")"Temperature at nodal point 8";

//==================================
//Equation section

equation

-(4*T1)+T2+T5=-1200;
T1-(4*T2)+T3+T6=-600;
T2-(4*T3)+T4+T7=-600;
(2*T1)-(4*T5)+T6=-600;
(2*T2)+T5-(4*T6)+T7=0;
(2*T3)+T6-(4*T7)+T8=0;
(2*T3)-(6*T4)+T8=-1400;
(2*T4)+(2*T7)-(6*T8)=-800;

end Ex3_3;
