//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 3:Multidimensional Steady-State Heat Conduction
//Example :3.6 page 119
//Topic:Cross section of square chimney
//===================================================================================

model Ex3_6

//=================================
//parameter section

parameter Real k(unit="W/mK")=2"Thermal conductivity of the concrete";
parameter Real h(unit="W/m^2K")=20"Heat transfer coeffient of the chimney";
parameter Real Tg(unit="degree celcius")=400"Temperature of hot gas flowing inside chimney";
parameter Real To(unit="degree celcius")=20"Ambient temperature";
parameter Real x(unit="m")=0.1"Grid size";
parameter Real y(unit="m")=0.1"Grid size";

//================================
//Variable section

Real T1(unit="degree celcius")"Temperature at node 1";
Real T2(unit="degree celcius")"Temperature at node 2";
Real T3(unit="degree celcius")"Temperature at node 3";
Real T4(unit="degree celcius")"Temperature at node 4";
Real T5(unit="degree celcius")"Temperature at node 5";
Real T6(unit="degree celcius")"Temperature at node 6";
Real T7(unit="degree celcius")"Temperature at node 7";
Real T8(unit="degree celcius")"Temperature at node 8";
Real T9(unit="degree celcius")"Temperature at node 9";

//==================================
//Equation section

equation
-(3*T1)+T2+T3=-400;
T1-(4*T2)+(2*T4)=-400;
(2*T4)+T1+T6-(4*T3)=0;
T2+T3-(4*T4)+T5+T7=0;
(2*T4)-(4*T5)+(2*T8)=0;
T3-(3*T6)+T7=-20;
(2*T4)+T6-(6*T7)+T8=-40;
(2*T5)+T7-(6*T8)+T9=-40;
T8-(2*T9)=-20;

end Ex3_6;
