//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.10 page 164
//Topic:Applications of the solutions of One-dimensional transient heat conduction to multidimensional system
//===================================================================================

model Ex4_10

//=================================
//parameter section

parameter Real l(unit="mm")=300"Length of the rectangular iron beam";
parameter Real b(unit="mm")=200"Breath of the rectangular iron beam";
parameter Real Ti(unit="degree celcius")=30"Initial temperature of the beam";
parameter Real Tg(unit="degree celcius")=730"Temperature of the hot gas";
parameter Real h(unit="W/m^2K")=100"Convective heat transfer of the beam";
parameter Real To(unit="degree celcius")=310"Final temperature";
parameter Real k(unit="W/mK")=73"Thermal conductivity of the beam";
parameter Real a(unit="m^2/s")=2.034e-5"Thermal diffusivity of the beam ";
parameter Real t1(unit="seconds")=900"First time assumption";
parameter Real t2(unit="seconds")=1200"Second time assumption";
parameter Real Tp1a(unit="")=0.85"Temperature ratio for plate 1 at first assumption from graph 4.11";
parameter Real Tp2a(unit="")=0.8"Temperature ratio for plate 2 at first assumption from graph 4.11";
parameter Real Tp1b(unit="")=0.83"Temperature ratio for plate 1 at second assumption from graph 4.11";
parameter Real Tp2b(unit="")=0.72"Temperature ratio for plate 2 at second assumption from graph 4.11";

//================================= 
//Variable section

Real Tb(unit="")"Temperature ratio of beam";
Real L1(unit="m")"Length of plate 1";
Real L2(unit="m")"Length of plate 2";
Real Bi11(unit="")"Biot number for plate 1 at first assumption";
Real Fo11(unit="")"Fourier number for plate 1 at first assumption";
Real Bi21(unit="")"Biot number for plate 2 at first assumption";
Real Fo21(unit="")"Fourier number for plate 2 at first assumption";
Real Fo12(unit="")"Fourier number for plate 1 at second assumption";
Real Fo22(unit="")"Fourier number for plate 2 at second assumption";
Real tf(unit="minutes")"Final time required"; 

//=================================
//Equation section

equation

Tb=(To-Tg)/(Ti-Tg);
L1=(l*1e-3)/2;
L2=(b*1e-3)/2;
Bi11=(h*L1)/k;
Fo11=(a*t1)/(L1^2);
//Tp1a=0.85 from figure(graph) 4.11 at Fo11 and (1/Bi11)
Bi21=(h*L2)/k;
Fo21=(a*t1)/(L2^2);
//Tp2a=0.8 from figure(graph) 4.11 at Fo21 and (1/Bi21)
Fo12=(a*t2)/(L1^2);
////Tp1b=0.83 from figure(graph) 4.11 at Fo12 and (1/Bi11)
Fo22=(a*t2)/(L2^2);
//Tp2b=0.72 from figure(graph) 4.11 at Fo22 and (1/Bi21)
if Tb>=(Tp1a*Tp2a) then
tf=t1/60;
else
tf=t2/60;
end if;

end Ex4_10;
