//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.11 page 170
//Topic:Transient heat flow in a semi-infinite Solid
//===================================================================================

model Ex4_11
extends Modelica.Math;

//=================================
//parameter section

parameter Real Ti(unit="degree celcius")=550"Initial temperature of the slab";  
parameter Real Ts(unit="degree celcius")=50"Temperature change in one side of the slab";
parameter Real T(unit="degree celcius")=255"Final temperature of the slab";
parameter Real x(unit="mm")=80"Depth of the slab";
parameter Real a(unit="m^2/s")=1.6e-5"Thermal diffusivity of the slab";
parameter Real k(unit="W/mK")=60"Thermal conductivity of the slab";

//=================================
//Variable section

Real t(unit="minutes")"Time to attain required temperature";

//=================================
//Equation section

equation

//(10/(t)^(1/2))=0.38 , the value is taken from Table 4.4
10/(sqrt(t*60))=0.38;

end Ex4_11;
