//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.14 page 192
//Topic:Numerical Methods for Transient heat flow
//===================================================================================

model Ex4_14

//=================================
//parameter section

parameter Real T1(unit="degree celcius")=580"Temperature at node 1";

//=================================
//Variable section

Real T2a(unit="degree celcius")"Temperature at node 2 at t=500s";
Real T3a(unit="degree celcius")"Temperature at node 3 at t=500s";
Real T4a(unit="degree celcius")"Temperature at node 4 at t=500s";
Real T5a(unit="degree celcius")"Temperature at node 5 at t=500s";
Real T6a(unit="degree celcius")"Temperature at node 6 at t=500s";
Real T7a(unit="degree celcius")"Temperature at node 7 at t=500s";
Real T2b(unit="degree celcius")"Temperature at node 2 from t=500s to t=1000s";
Real T3b(unit="degree celcius")"Temperature at node 3 from t=500s to t=1000s";
Real T4b(unit="degree celcius")"Temperature at node 4 from t=500s to t=1000s";
Real T5b(unit="degree celcius")"Temperature at node 5 from t=500s to t=1000s";
Real T6b(unit="degree celcius")"Temperature at node 6 from t=500s to t=1000s";
Real T7b(unit="degree celcius")"Temperature at node 7 from t=500s to t=1000s";
Real T2c(unit="degree celcius")"Temperature at node 2 from t=1000s to t=1500s";
Real T3c(unit="degree celcius")"Temperature at node 3 from t=1000s to t=1500s";
Real T4c(unit="degree celcius")"Temperature at node 4 from t=1000s to t=1500s";
Real T5c(unit="degree celcius")"Temperature at node 5 from t=1000s to t=1500s";
Real T6c(unit="degree celcius")"Temperature at node 6 from t=1000s to t=1500s";
Real T7c(unit="degree celcius")"Temperature at node 7 from t=1000s to t=1500s";

//=================================
//Equation section

equation

(-3*T2a)+T3a=-600;
T2a-(3*T3a)+T4a=-20;
T3a-(3*T4a)+T5a=-20;
T4a-(3*T5a)+T6a=-20;
T5a-(3*T6a)+T7a=-20;
(2*T6a)-(3*T7a)=-20;
(-3*T2b)+T3b=-813.913;
T2b-(3*T3b)+T4b=-101.739;
T3b-(3*T4b)+T5b=-51.304;
T4b-(3*T5b)+T6b=-32.174;
T5b-(3*T6b)+T7b=-25.217;
(2*T6b)-(3*T7b)=-23.478;
(-3*T2c)+T3c=-909.63;
T2c-(3*T3c)+T4c=-174.977;
T3c-(3*T4c)+T5c=-93.562;
T4c-(3*T5c)+T6c=-54.404;
T5c-(3*T6c)+T7c=-37.478;
(2*T6c)-(3*T7c)=-32.811;

 
end Ex4_14;
