//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 4:Unsteady Conduction
//Example :4.7 page 157
//Topic:A large cylinder
//===================================================================================

package Ex4_7

//===================================================================================

model Ex4_7_a
extends Modelica.Constants;

//=================================
//parameter section

parameter Real ro(unit="mm")=150"Radius of the cylinder";
parameter Real Ti(unit="degree celcius")=530"Initial uniform temperature of the cylinder";
parameter Real Ta(unit="degree celcius")=30"Ambient temperature";
parameter Real h(unit="W/m^2K")=380"Convective heat transfer coefficient between cylinder and the environment";
parameter Real k(unit="W/mK")=200"Thermal conductivity of the cylinder";
parameter Real a(unit="m^2/s")=8.5e-5"Thermal diffusivity of the cylinder";
parameter Real r(unit="mm")=120"Radius at which temperature to be found"; 
parameter Real t(unit="seconds")=265"Time at which cylinder is exposed to environment";
parameter Real L(unit="m")=1"Length of the cylinder";

//=================================
//Variable section

Real Fo(unit="")"Fourier number";
Real Bi(unit="")"Biot number";
Real T(unit="degree celcius")"Temperature at given radius";

//=================================
//Equation section

equation
Fo=(a*t)/((ro/1000)^2);
Bi=(h*ro)/(1000*k);
//(To-Ta)/(Ti-Ta)=0.6 taken from figure(graph) 4.15 at (1/Bi) and Fo
//(T-Ta)/(To-Ta)=0.9 taken from figure(graph) 4.16 at (1/Bi) and (r/ro)
T=Ta+(0.9*0.6*(Ti-Ta));

end Ex4_7_a; 
//===================================================================================

model Ex4_7_b
extends Ex4_7_a;

//=================================
//Variable section

Real Qi(unit="MJ")"Initial energy of the cylinder";
Real Q(unit="MJ/m")"Heat transfer per unit length";

//=================================
//Equation section

equation
Qi=(k/a)*pi*((ro/1000)^2)*L*(Ti-Ta)*1e-6;
Q=0.4*Qi/L;//(Q/Qi) ratio is 0.4 from figure(graph) 4.17 at Fo(Bi^2) and Bi
end Ex4_7_b;
//===================================================================================
end Ex4_7;
