//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 5:Convection
//Example :5.3 page 215
//Topic:Flat plate with a free stream velocity
//===================================================================================

model Ex5_3

//=================================
//parameter section

parameter Real u(unit="m/s")=1"Velocity of the stream";
parameter Real L(unit="m")=1"Length of the plate";
parameter Real T(unit="degree celcius")=100"Temperature at which the plate is heated";
parameter Real To(unit="degree celcius")=20"Temperature of air";
parameter Real Mu(unit="kg/(ms)")=1.9e-5"Viscosity of air";
parameter Real rho(unit="kg/m^3")=1.05"Density of air";
parameter Real k(unit="W/mK")=0.03"Thermal conductivity of air";
parameter Real Cp(unit="kJ/kgK")=1.007"Specific heat capacity";
parameter Real Pr(unit="")=0.7"Prandtl Number";

//=================================
//Variable section

Real Rel(unit="")"Reynolds Number at L=1m";
Real hl(unit="W/m^2K")"Heat transfer coefficient";
Real Q(unit="W/m")"Rate of heat transfer per unit length";

//=================================
//Equation section

equation

Rel=(L*u*rho)/Mu;
//Rex=(x*u*rho)/Mu;
//hx=k*0.332*((Rex)^0.5)*(Pr^(1/3))/x;
hl=2*2.08*1;//hl obtained after integrating hx and substituting the limits (1 , 0)
Q=hl*L*(T-To);

end Ex5_3;
