//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 5:Convection
//Example :5.4 page 216
//Topic:Circuit board to cool the electronic elements
//===================================================================================

model Ex5_4

//=================================
//parameter section

parameter Real L(unit="mm")=3"Length of the chip";
parameter Real B(unit="mm")=3"Width of the chip";
parameter Real x(unit="m")=0.1"Distance of chip from the Leading edge ";
parameter Real Q(unit="mW")=50"Energy dissipated by the chip";
parameter Real T(unit="degree celcius")=45"Temperature of the chip";
parameter Real To(unit="degree celcius")=25"Temperature of air";
parameter Real rho(unit="kg/m^3")=1.2"Density of air";
parameter Real Mu(unit="kg/ms")=1.8e-5"Viscosity of air";
parameter Real k(unit="W/mK")=0.03"Thermal conductivity of air";
parameter Real Cp(unit="J/kgK")=1000"Specific heat capacity of air";

//=================================
//Variable section

Real hx(unit="W/m^2K")"Heat transfer coefficient at x distance";
Real u(unit="m/s")"Minimum flow velocity";

//=================================
//Equation section

equation

hx=(k/x)*0.06*((x*u*rho/Mu)^0.85)*((Cp*Mu/k)^0.33);// from the given relation
Q*1e-3=hx*(L*B*1e-6)*(T-To);

end Ex5_4;
