//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 5:Convection
//Example :5.7 page 219
//Topic:Heat loss from vertical wall
//===================================================================================

model Ex5_7

//=================================
//parameter section

parameter Real Ta(unit="degree celcius")=4"Temperature of nitrogen";
parameter Real Ts(unit="degree celcius")=56"Temperature of the wall";
parameter Real H(unit="m")=2"Height of the wall";
parameter Real B(unit="m")=2.5"Width of the wall";
parameter Real rho(unit="kg/m^3")=1.142"Density of nitrogen";
parameter Real k(unit="W/mK")=0.026"Thermal conductivity of nitrogen";
parameter Real v(unit="m^2/s")=15.63e-6"Kinematic viscosity";
parameter Real Pr(unit="")=0.713"Prandtl number";

//=================================
//Variable section

Real T(unit="degree celcius")"Mean temperature";
Real Gr(unit="")"Grashoff number";
Real Nu(unit="")"Nusselt number";
Real h(unit="W/m^2K")"Heat transfer coefficient";
Real Q(unit="W")"Heat loss from the plate";

//=================================
//Equation section

equation

T=(Ta+Ts)/2;
Gr=(1/(T+273))*9.81*(Ts-Ta)*(H^3)/(v^2);
Nu=0.13*(Gr*Pr)^(1/3);
h=(Nu*k)/H;
Q=h*H*B*(Ts-Ta);

end Ex5_7;
