//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 6:Incompressible Viscous Flow : A Brief Review
//Example :6.10 page 284
//Topic:A Brief Introduction to Turbulent Flow
//===================================================================================

model Ex6_10

//=================================
//parameter section

parameter Real u1(unit="km/h")=36"Speed of the wind";
parameter Real L(unit="m")=6"Length of the plate";
parameter Real rho(unit="kg/m^3")=1.2"Density of air";
parameter Real v(unit="m^2/s")=1.5e-5"Kinematic viscosity of air";

//=================================
//Variable section

Real u(unit="m/s")"Velocity of air";
Real Rel(unit="")"Reynolds Number";
Real Cfl(unit="")"Skin friction coefficient";
Real FD(unit="N")"Drag force on one side of the plate";
Real t(unit="mm")"Thickness of the boundry layer";

//=================================
//Equation section

equation

u=(u1*1e3)/3600;
Rel=(u*L)/v;
Cfl=(0.074/(Rel^(1/5)))-(1742/Rel);
FD=Cfl*rho*(u^2)*L*0.5;
t=L*(0.379/(Rel^(1/5)))*1e3;

end Ex6_10;
