//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 6:Incompressible Viscous Flow : A Brief Review
//Example :6.7 page 266
//Topic:Boundry Layer Seperation
//===================================================================================

model Ex6_7

//=================================
//parameter section

parameter Real W(unit="m")=1.2"Width of the plate";
parameter Real u(unit="m/s")=3"Velocity of air flowing";
parameter Real Rex(unit="")=5e5"Reynolds number at laminar flow";
parameter Real rho(unit="kg/m^3")=1.2"Density of air";
parameter Real v(unit="m^2/s")=1.5e-5"Kinematic viscosity of air";

//=================================
//Variable section

Real L(unit="m")"Maximum length of the plate";
Real Cfl(unit="")"Skin friction coefficient";
Real FD(unit="N")"Drag force";

//=================================
//Equation section

equation

L=(Rex*v)/u;
Cfl=1.328/(Rex^0.5);
FD=Cfl*(0.5*rho*u^2)*W*L;

end Ex6_7;
