//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.1 page 317
//Topic:Engine oil flows over a plate
//===================================================================================

model Ex7_1

//=================================
//parameter section

parameter Real Te(unit="degree celcius")=60"Temperature of engine oil";
parameter Real Tp(unit="degree celcius")=30"Temperature of the plate";
parameter Real L(unit="m")=5"Length of the plate";
parameter Real Tf(unit="degree celcius")=45"Film temperature";
parameter Real u(unit="m/s")=1"Velocity with which the oil flows";
//Properties of oil at film temperature
parameter Real rho(unit="kg/m^3")=870"Density of engine oil";
parameter Real k(unit="W/mK")=0.145"Thermal conductivity of engine oil";
parameter Real v(unit="m^2/s")=250e-6"Kinematic viscosity";
parameter Real Pr(unit="")=2850"Prandtl number";

//=================================
//Variable section

Real Re(unit="")"Reynolds number";
Real Nu(unit="")"Nusselt number";
Real h(unit="W/m^2K")"Heat transfer coefficient ";
Real Q(unit="kW")"Heat transfer rate per unit width"; 

//=================================
//Equation section

equation

Re=(u*L)/v;
Nu=0.664*(Re^0.5)*(Pr^(1/3));
h=(k/L)*Nu;
Q=h*L*(Te-Tp)*1e-3;

end Ex7_1;
