//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.11 page 342
//Topic:Liquid sulphur dioxide
//===================================================================================

model Ex7_11
extends Modelica.Constants;

//=================================
//parameter section

parameter Real L(unit="m")=5"Length of the tube";
parameter Real d(unit="mm")=25"Diameter of the tube";
parameter Real m(unit="kg/s")=0.15"Mass flow rate of liquid";
parameter Real Tw(unit="degree celcius")=-10"Constant surface temperature";
parameter Real Tbi(unit="degree celcius")=-40"Inlet temperature of fluid";
parameter Real Tbo1(unit="degree celcius")=-20"Outlet temperature of fluid (assumed value)";
//properties of fluid at bulk mean temperature 1
parameter Real rho1(unit="kg/m^3")=1520.64"Density of fluid";
parameter Real v1(unit="m^2/s")=0.371e-6"Kinematic viscosity";
parameter Real k1(unit="W/mK")=0.23"Thermal conductivity";
parameter Real Pr1(unit="")=3.31"Prandtl number";
parameter Real Cp1(unit="kJ/kgK")=1361.6"Specific heat";
//properties of fluid at bulk mean temperature 2
parameter Real rho2(unit="kg/m^3")=1514"Density of fluid";
parameter Real v2(unit="m^2/s")=0.362e-6"Kinematic viscosity";
parameter Real k2(unit="W/mK")=0.229"Thermal conductivity";
parameter Real Pr2(unit="")=3.23"Prandtl number";
parameter Real Cp2(unit="kJ/kgK")=1362"Specific heat";
parameter Real vw(unit="m^2/s")=0.288e-6"Kinematic viscosity at -10 degree celcius";
parameter Real rhow(unit="kg/m^3")=1463.61"Density at -10 degree celcius";

//=================================
//Variable section

Real Mu1(unit="kg/ms")"Viscosity of fluid at first trial";
Real Muw(unit="kg/ms")"Viscosity at -10 degree celcius";
Real Mu2(unit="kg/ms")"Viscosity of fluid at second trial";
Real Re1(unit="")"Reynolds number at first trial";
Real Nu1(unit="")"Nusselt number at first trial";
Real h1(unit="W/m^2K")"Heat transfer coefficient at first trial";
Real Tbo2(unit="degree celcius")"Outlet fluid temperature at first trial";
Real Tb1(unit="degree celcius")"first bulk mean temperature";
Real Tb2(unit="degree celcius")"second bulk mean temperature";
Real Re2(unit="")"Reynolds number at second trial";
Real Nu2(unit="")"Nusselt number at second trial";
Real h2(unit="W/m^2K")"Heat transfer coefficient at second trial";
Real Tbo3(unit="degree celcius")"Outlet fluid temperature at second trial";
Real Tb3(unit="degree celcius")"Third bulk mean temperature";

//=================================
//Equation section

equation

Tb1=(Tbi+Tbo1)/2;
Mu1=v1*rho1;
Muw=vw*rhow;
Mu2=v2*rho2;
Re1=(4*m)/(pi*d*Mu1*1e-3);
Nu1=0.027*(Re1^0.8)*(Pr1^(1/3))*((Mu1/Muw)^0.14);
h1=(k1/(d*1e-3))*Nu1;
Tbo2=Tw-((Tw-Tbi)*(exp(((-pi*d*L*h1*1e-3)/(m*Cp1)))));
Tb2=(Tbi+Tbo2)/2;
Re2=(4*m)/(pi*d*Mu2*1e-3);
Nu2=0.027*(Re2^0.8)*(Pr2^(1/3))*((Mu2/Muw)^0.14);
h2=(k1/(d*1e-3))*Nu2;
Tbo3=Tw-((Tw-Tbi)*(exp(((-pi*d*L*h2*1e-3)/(m*Cp2)))));
Tb3=(Tbi+Tbo3)/2;


end Ex7_11;
