//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.6 page 321
//Topic:Wing absorbs solar radiation
//===================================================================================

model Ex7_6

//=================================
//parameter section

parameter Real u(unit="m/s")=150"Velocity of aircraft";
parameter Real To(unit="degree celcius")= -5 "Ambient Temperature of aircraft";
parameter Real qr(unit="W/m^2")=900"Radiation heat flux";
parameter Real L(unit="m")=2"Length of the wing(considering as a flat plate)";
//Properties of air at 268 K and 0.7 bar
parameter Real k(unit="W/mK")=0.024"Thermal conductivity of air";
parameter Real Pr(unit="")=0.72"Prandtl number";
parameter Real v(unit="m^2/s")=2e-5"Kinematic viscosity of air";

//=================================
//Variable section

Real ReL(unit="")"Reynolds Number";
Real NuL(unit="")"Nusselt number";
Real hL(unit="W/m^2K")"Heat transfer coefficient at L";
Real Tw(unit="K")"Surface temperature of the wing";

//=================================
//Equation section

equation

ReL=(u*L)/v;
NuL=(5/4)*0.0308*(ReL^(4/5))*(Pr^(1/3));
hL=(NuL*k)/L;
Tw=(To+273)+(qr/(2*hL));

end Ex7_6;
