//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 7:Principles of forced convection
//Example :7.9 page 340
//Topic:Heat transfer to liquid metals in pipe flow
//===================================================================================

package Ex7_9

//==========================================================
model Ex7_9_a

//=================================
//parameter section

parameter Real Tbi(unit="degree celcius")=75"Temperature of air at inlet";
parameter Real Tbo(unit="degree celcius")=125"Temperature of air at outlet";
parameter Real u(unit="m/s")=2"Average velocity of air";
parameter Real d(unit="mm")=4"Internal dia of tube";
parameter Real Nu(unit="")=4.36"Nusselt number at fully devoloped flow";
//properties of air at mean temperature
parameter Real rho(unit="kg/m^3")=0.95"Density of air";
parameter Real Cp(unit="kJ/kgK")=1.01"Specific heat of air";
parameter Real Mu(unit="kg/ms")=2.18e-5"Viscosity of air";
parameter Real k(unit="W/mK")=0.03"Thermal conductivity of air";
parameter Real Pr(unit="")=0.7"Prandtl number";

//=================================
//Variable section

Real Re(unit="")"Reynolds number";
Real Leh(unit="m")"Hydrodynamic entrance length";
Real Let(unit="m")"Thermal entrance length";
Real h(unit="W/m^2 K")"Heat transfer coefficient";

//=================================
//Equation section

equation

Re=rho*(d*1e-3)*u/Mu;
Leh=0.05*Re*d*1e-3;
Let=0.05*Re*d*Pr*1e-3;
h=Nu*k/(d*1e-3);

end Ex7_9_a;

//==========================================================

model Ex7_9_b
extends Ex7_9_a;

//=================================
//Variable section

Real m(unit="kg/s")"Mass flow rate of air";
Real qw(unit="W/m^2")"Heat flux ";

//=================================
//Equation section

equation

m=rho*(3.14/4)*((d*1e-3)^2)*u;
qw=(m*Cp*1000*(Tbo-Tbi))/(3.14*d*1e-3);

end Ex7_9_b;

//==========================================================

model Ex7_9_c
extends Ex7_9_a;
extends Ex7_9_b;

//=================================
//Variable section

Real Twe(unit="degree celcius")"Surface temperature of tube at exit";

//=================================
//Equation section

equation

Twe=Tbo+(qw/h);

end Ex7_9_c;

//==========================================================

end Ex7_9;
