//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 8:Principles of free convection
//Example :8.4 page 373
//Topic:Square plate suspended vertically
//===================================================================================

package Ex8_4

//=========================================================================

model Ex8_4_a
extends Modelica.Constants;

//=================================
//parameter section

parameter Real x(unit="m")=0.2"Boundry Layer at edge of the plate";
parameter Real b(unit="m")=0.2"Width of the plate";
parameter Real L(unit="m")=0.2"Length of the plate";
parameter Real Tw(unit="K")=400"Temperature of the plate";
parameter Real To(unit="K")=300"Temperature of air";
//Properties at mean film temperature
parameter Real k(unit="W/mK")=0.03"Thermal conducivity ";
parameter Real v(unit="m^2/s")=20.75e-6"kinematic viscosity";
parameter Real Pr(unit="")=0.69"Prandtl number";

//=================================
//Variable section

Real B(unit="K^-1")"";
Real Tf(unit="K")"Mean film temperature";
Real Gr(unit="")"Grashoff number";
Real Ra(unit="")"Reynolds number";
Real d(unit="m")"Boundry layer thickness";

//=================================
//Equation section

equation

Tf=(Tw+To)/2;
B=1/Tf;
Gr=(g_n*B*(Tw-To)*(x^3))/(v^2);
Ra=Gr*Pr;
d=(x*3.93*((0.952+Pr)^(1/4)))/((Pr^0.5)*(Gr^(1/4)));

end Ex8_4_a;
//=========================================================================

model Ex8_4_b
extends Ex8_4_a;

//=================================
//Variable section

Real hL(unit="W/m^2K")"Average heat transfer coefficient";

//=================================
//Equation section

equation

hL=(8*k)/(3*d);

end Ex8_4_b;
//=========================================================================
end Ex8_4;

//==============================================================================
//Remarks
//The answer of Thickness is wrong in the book.
//The actual answer by calculator is 0.01261364
