//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 8:Principles of free convection
//Example :8.6 page 376
//Topic:Long vertical wire in atmosphere
//===================================================================================

model Ex8_6
extends Modelica.Constants;
extends Modelica.Math;

//=================================
//parameter section

parameter Real d(unit="mm")=0.1"Diameter of the wire";
parameter Real L(unit="m")=0.5"Length of the wire";
parameter Real Tw(unit="K")=400"Temperature of wire";
parameter Real To(unit="K")=300"Temperature of air";
parameter Real Res(unit="ohm")=0.12"Resistance of the wire";
//Properties at mean film temperature
parameter Real k(unit="W/mK")=0.03"Thermal conducivity ";
parameter Real v(unit="m^2/s")=20.75e-6"kinematic viscosity";
parameter Real Pr(unit="")=0.7"Prandtl number";
parameter Real Co(unit="")=0.59"Constant";
parameter Real n(unit="")=0.25"Constant";

//=================================
//Variable section

Real D(unit="m")"Diameter of the wire";
Real Tf(unit="degree celcius")"Film Temperature";
Real B(unit="K^-1")"";
Real GrL(unit="")"Grashoff number";
Real RaL(unit="")"Reynolds number";
Real NuL(unit="")"Nusselt number";
Real hL1(unit="W/m^2K")"Heat transfer coefficient";
Real GrD(unit="")"Grashoff number ";
Real F(unit="")"Correction factor";
Real hL(unit="W/m^2K")"Corrected value of heat transfer coefficient";
Real I(unit="A")"Ohmic power loss";

//=================================
//Equation section

equation

D=d*1e-3;
Tf=(Tw+To)/2;
B=1/Tf;
GrL=(g_n*B*(Tw-To)*(L^3))/(v^2);
RaL=GrL*Pr;
NuL=Co*(RaL^n);
hL1=(NuL*k)/L;
GrD=GrL*((D/L)^3);
F=(1.3*((L/D)/GrD)^0.25)+1;
hL=F*hL1;
I=sqrt((hL*pi*D*L*(Tw-To))/(Res*L));

end Ex8_6;
