//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 8:Principles of free convection
//Example :8.8 page 377
//Topic:Electric immersion heater
//===================================================================================

model Ex8_8
extends Modelica.Constants;

//=================================
//parameter section

parameter Real d(unit="mm")=8"Diameter of the heater";
parameter Real l(unit="mm")=300"Length of the heater";
parameter Real P(unit="W")=450"Power input";
parameter Real To(unit="degree celcius")=20"Temperature of ambient air";
parameter Real Tw1(unit="degree celcius")=64"Trial value of surface Temperature";
//Properties at mean film temperature
parameter Real k(unit="W/mK")=0.634"Thermal conducivity ";
parameter Real v(unit="m^2/s")=6.25e-7"kinematic viscosity";
parameter Real Pr(unit="")=4.16"Prandtl number";
parameter Real B(unit="K^-1")=4e-4"";

//=================================
//Variable section

Real D(unit="m")"Diameter of the heater";
Real L(unit="m")"Length of the heater";
Real Tf(unit="degree celcius")"Film Temperature";
Real GrD(unit="")"Grashoff number";
Real RaD(unit="")"Reynolds number";
Real NuD(unit="")"Nusselt number";
Real hD(unit="W/m^2K")"Heat transfer coefficient";
Real Tw(unit="degree celcius")"Surface temperature of the heater";

//=================================
//Equation section

equation

D=d*1e-3;
L=l*1e-3;
Tf=(Tw1+To)/2;
GrD=(g_n*B*(Tw1-To)*(D^3))/(v^2);
RaD=GrD*Pr;
NuD=(0.6+((0.387*(RaD^(1/6)))/((1+((0.559/Pr)^(9/16)))^(8/27))))^2;
hD=(NuD*k)/D;
Tw=To+(P/(pi*hD*L*D));


end Ex8_8;

//==============================================================================
//Remarks
//The value of kinematic viscosity is given wrongly in question,but substituted correctly in the problem.
