//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 9:Heat transfer in Condensation and boiling
//Example :9.1 page 399
//Topic:A vertical cooling fin
//===================================================================================

model Ex9_1
extends Modelica.Constants;

//=================================
//parameter section

parameter Real hf(unit="m")=0.4"Height of the flat plate";
parameter Real Tg(unit="degree celcius")=100"Temperature of the water";
parameter Real Tw(unit="degree celcius")=90"Temperature of the fin";
//Properties at mean film temperature
parameter Real rho(unit="kg/m^3")=962"Density of water";
parameter Real k(unit="W/mK")=0.677"Thermal conductivity of water";
parameter Real Mu(unit="kg/ms")=3e-4"Viscosity of water";
parameter Real rhov(unit="kg/m^3")=0.598"Density of the steam";
parameter Real hfg(unit="J/kg")=2.27e6"Specific enthalpy";

//=================================
//Variable section

Real hL(unit="W/m^2K")"Heat transfer coefficient";
Real Q(unit="W/m")"Heat transfer per unit width";
Real mc(unit="kg/ms")"Rate of condensation";
Real ReL(unit="")"Reynolds number";

//=================================
//Equation section

equation

hL=0.943*(((rho*(rho-rhov)*g_n*hfg*(k^3))/(Mu*hf*(Tg-Tw)))^0.25);
Q=hL*hf*(Tg-Tw);
mc=Q/hfg;
ReL=(4*mc)/Mu;

end Ex9_1;
