//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 9:Heat transfer in Condensation and boiling
//Example :9.2 page 399
//Topic:Steam is being condensed
//===================================================================================

model Ex9_2
extends Modelica.Constants;

//=================================
//parameter section

parameter Real L(unit="m")=3"Length of the tube";
parameter Real d(unit="mm")=50"Diameter of the tube";
parameter Real Tg(unit="degree celcius")=100"Temperature of the steam";
parameter Real Tw(unit="degree celcius")=90"Temperature of the tube surface";
//Properties at mean film temperature
parameter Real rho(unit="kg/m^3")=962"Density of water";
parameter Real k(unit="W/mK")=0.677"Thermal conductivity of water";
parameter Real Mu(unit="kg/ms")=3e-4"Viscosity of water";
parameter Real rhov(unit="kg/m^3")=0.598"Density of the steam";
parameter Real hfg(unit="J/kg")=2.27e6"Specific enthalpy";

//=================================
//Variable section

Real D(unit="m")"Diameter of the tube";
Real hL(unit="W/m^2K")"Heat transfer coefficient";
Real mc(unit="kg/s")"Rate of condensation";
Real ReL(unit="")"Reynolds number";

//=================================
//Equation section

equation

D=d*1e-3;
hL=0.725*(((rho*(rho-rhov)*g_n*hfg*(k^3))/(Mu*D*(Tg-Tw)))^0.25);
mc=(hL*pi*D*L*(Tg-Tw))/hfg;
ReL=(2*mc)/(Mu*L);

end Ex9_2;
