//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 9:Heat transfer in Condensation and boiling
//Example :9.3 page 400
//Topic:Vertical plate in the prescence of saturated steam
//===================================================================================

package Ex9_3

//=========================================================================

model Ex9_3_a
extends Modelica.Constants;

//=================================
//parameter section

parameter Real L(unit="m")=01.5"Height of the plate";
parameter Real B(unit="m")=0.3"Width of the plate";
parameter Real Tg(unit="degree celcius")=100"Temperature of the water";
parameter Real Tw(unit="degree celcius")=60"Temperature of the plate";
//Properties at mean film temperature
parameter Real rho(unit="kg/m^3")=972"Density of water";
parameter Real Cp(unit="J/kgK")=4.2"Specific heat";
parameter Real k(unit="W/mK")=0.67"Thermal conductivity of water";
parameter Real Mu(unit="kg/ms")=3.54e-4"Viscosity of water";
parameter Real rhov(unit="kg/m^3")=0.598"Density of the steam";
parameter Real hfg(unit="J/kg")=2.27e6"Specific enthalpy";

//=================================
//Variable section

Real hL(unit="W/m^2K")"Heat transfer coefficient";
Real Q(unit="kW")"Heat transfer";

//=================================
//Equation section

equation

hL=0.943*(((rho*(rho-rhov)*g_n*hfg*(k^3))/(Mu*L*(Tg-Tw)))^0.25);
Q=hL*L*B*(Tg-Tw)*1e-3;

end Ex9_3_a;

//=========================================================================

model Ex9_3_b
extends Ex9_3_a;

//=================================
//Variable section

Real d(unit="mm")"Thickness of the film";
Real mc(unit="kg/s")"Rate of condensation";
Real Ve(unit="m/s")"Average flow velocity";

//=================================
//Equation section

equation

d=(((4*Mu*k*L*(Tg-Tw))/(g_n*hfg*rho*(rho-rhov)))^0.25)*1e3;
mc=(Q*1e3)/hfg;
Ve=(mc*1e3)/(rho*d*B);

end Ex9_3_b;


//=========================================================================
end Ex9_3;
