//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 9:Heat transfer in Condensation and boiling
//Example :9.4 page 401
//Topic:Saturated Freon-12
//===================================================================================

model Ex9_4
extends Modelica.Constants;

//=================================
//parameter section

parameter Real L(unit="m")=1"Length of the tube";
parameter Real d(unit="mm")=15"Diameter of the tube";
parameter Real Tg(unit="degree celcius")=35"Temperature of the Saturated Freon-12";
parameter Real Tw(unit="degree celcius")=25"Temperature of the tube";
//Properties at mean film temperature
parameter Real rho(unit="kg/m^3")=1290"Density of water";
parameter Real Cp(unit="J/kgK")=983"Specific heat";
parameter Real k(unit="W/mK")=0.071"Thermal conductivity of water";
parameter Real Mu(unit="kg/ms")=2.5e-4"Viscosity of water";
parameter Real rhov(unit="kg/m^3")=42.68"Density of the Freon-12";
parameter Real hfg(unit="kJ/kg")=131.33"Specific enthalpy";

//=================================
//Variable section

Real D(unit="m")"Diameter of the tube";
Real hfg1(unit="J/kg")"Modified enthalpy of vapurization";
Real hD(unit="W/m^2K")"Heat transfer coefficient";
Real mc(unit="kg/h")"Total rate of condensation";

//=================================
//Equation section

equation

D=d*1e-3;
hfg1=(hfg*1e3)+((3*Cp*(Tg-Tw))/8);
hD=0.555*(((rho*(rho-rhov)*g_n*hfg1*(k^3))/(Mu*D*(Tg-Tw)))^0.25);
mc=(hD*pi*D*L*(Tg-Tw)*3600)/(hfg*1e3);

end Ex9_4;
