//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 9:Heat transfer in Condensation and boiling
//Example :9.6 page 407
//Topic:Nickel wire submerged horizontally
//===================================================================================

model Ex9_6
extends Modelica.Constants;

//=================================
//parameter section

parameter Real I(unit="A")=100"Current required to burn the nickel wire";
parameter Real L(unit="m")=0.3"Length of the nickel wire";
parameter Real d(unit="mm")=1"Diameter of the nickel wire";
parameter Real rhol(unit="kg/m^3")=960"Density of water";
parameter Real rhov(unit="kg/m^3")=0.6"Density of vapour";
parameter Real hfg(unit="J/kg")=2.26e6"Specific enthalpy";
parameter Real s(unit="N/m")=0.055"Surface tension of water";

//=================================
//Variable section section

Real qc(unit="W/m^2")"Heat flux";
Real E(unit="V")"Burnout voltage";

//=================================
//Equation section

equation

qc=0.149*hfg*rhov*(((s*g_n*(rhol-rhov))/(rhov^2))^0.25)*(((rhol+rhov)/rhol)^0.5);
E=(qc*pi*L*d*1e-3)/I;

end Ex9_6;
