//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 9:Heat transfer in Condensation and boiling
//Example :9.7 page 408
//Topic:A heated nickel plate
//===================================================================================

model Ex9_7
extends Modelica.Constants;

//=================================
//parameter section

parameter Real Tg(unit="degree celcius")=110"Temperature of the nickel plate";
parameter Real Tw(unit="degree celcius")=100"Saturation temperature of water";
parameter Real Csf(unit="")=0.006"Constant for nucleate boiling";
parameter Real n(unit="")=1"Constant for nucleate boiling";
parameter Real Cpl(unit="kJ/kgK")=4.216"Specific heat capacity of water";
parameter Real Mul(unit="kg/ms")=2.82e-4"Viscosity of water";
parameter Real Prl(unit="")=1.74"Prandtl number";
parameter Real rhol(unit="kg/m^3")=960"Density of water";
parameter Real rhov(unit="kg/m^3")=0.6"Density of vapour";
parameter Real hfg(unit="J/kg")=2.26e6"Specific enthalpy";
parameter Real s(unit="N/m")=0.055"Surface tension of water";

//=================================
//Variable section

Real q(unit="W/m^2")"Heat flux";

//=================================
//Equation section

equation

q=Mul*hfg*((g_n*(rhol-rhov)/s)^0.5)*(((Cpl*(Tg-Tw)*1e3)/(Csf*hfg*Prl))^3);

end Ex9_7;
