//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 9:Heat transfer in Condensation and boiling
//Example :9.8 page 408
//Topic:Boiling charecterstics of special coating
//===================================================================================

model Ex9_8
extends Modelica.Constants;

//=================================
//parameter section

parameter Real XA(unit="mm")=10"Distance of location A from surface";
parameter Real XB(unit="mm")=30"Distance of location B from surface";
parameter Real TA(unit="degree celcius")=140"Temperature at location A";
parameter Real TB(unit="degree celcius")=180"Temperature at location B";
parameter Real Cpl(unit="kJ/kgK")=4.216"Specific heat capacity of water";
parameter Real Mul(unit="kg/ms")=2.82e-4"Viscosity of water";
parameter Real Prl(unit="")=1.74"Prandtl number";
parameter Real rhol(unit="kg/m^3")=960"Density of water";
parameter Real rhov(unit="kg/m^3")=0.6"Density of vapour";
parameter Real hfg(unit="J/kg")=2.26e6"Specific enthalpy";
parameter Real s(unit="N/m")=0.055"Surface tension of water";
parameter Real k(unit="W/mK")=375"Thermal conductivity";

//=================================
//Variabloe section

Real q(unit="W/m^2")"Heat flux";
Real Tw(unit="degree celcius")"Surface temperature";
Real Csf(unit="")"Nucleate boiling constant";

//=================================
//Equation section

equation

q=k*((TB-TA)/((XB-XA)*1e-3));
Tw=TA-(XA*(TB-TA)/(XB-XA));
q=Mul*hfg*((g_n*(rhol-rhov)/s)^0.5)*(((Cpl*(Tw-100))/(Csf*hfg*Prl))^3);

end Ex9_8;

//===================================================================================
//Remarks
//Csf answer is calculated wrong in the book
//Answer obtained from calculator is 1.51329*10^-5
