//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 1:Fundamental Concepts
//Example :1.10 page 13
//Topic:A flat panel on spacecraft
//==============================================================================
model Ex1_10
extends Modelica.Constants;

//=============================
//Parameter section

parameter Real T0(unit="K")=0"Outer temperature";
parameter Real Ti(unit="K")=298"Inner temperature";
parameter Real em=0.8"emissivity";
parameter Real k(unit="W/mK")=5"Thermal conductivity of the flat panel";
parameter Real L(unit="m")=0.01"Thickness of the panel";
parameter Real h1(unit="W/m^2*K")=70"Average heat transfer coefficient";

//==============================
//Variable section
//Let Q/A=F

Real F(unit="W/m^2")"Rate of heat transfer";
Real T2(unit="K",start=285)"Outer surface temperature";
Real hr(unit="W/m^2*K")"Radiation heat transfer coefficient";

//==============================
//Equation section
equation
F=em*sigma*(T2^4-T0^4);//(sigma = stephan boltzman constant)
F=hr*(T2-0);
F=Ti/((1/h1)+(L/k)+(1/hr));

end Ex1_10;
//=================================================================
