//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 1: Fundamental Concepts
//Example : 1.2 page 4
//Topic:Thickness required of a masonry wall
//==============================================================================
model Ex1_2

//=========================
//Parameter section

parameter Real Q(unit="percent")=80"Percentage of heat flow";
parameter Real kc(unit="W/mK")=0.2"Thermal conductivity of composite wall";
parameter Real km(unit="W/mK")=0.8"Thermal conductivity of masonary wall";
parameter Real Lc(unit="mm")=100"Thickness of composite wall";

//=========================
//Variable section

Real Lm(unit="m")"Thickness of masonary wall";

//==========================
//Equation section
equation
//Using Equation 1.3 ratio of heat flow =Q=(km/kc)*(Lc/Lm)
Lm=((km/kc)*((Lc/1000)/(Q/100)));
end Ex1_2;
//========================================
