//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 1:Fundamental Concepts
//Example :1.5 page 9
//Topic:Forced flows over a convective heat exchanger
//======================================================================================
model Ex1_5

//=====================
//Parameter section

parameter Real Q(unit="MJ/h")=20"Rate of Heat transfer";
parameter Real h(unit="W/m^2*K")=800"Convective heat transfer coefficient";
parameter Real Ts(unit="degree celcius")=75"Surface temperature of heat transfer"; 
parameter Real Ta(unit="degree celcius")=25"Ambient temperature";

//======================
//Varaiable section

Real A(unit="m^2")"Surface area of heat exchanger";

//=======================
//Equation section
equation
A=(Q*1e6)/(3600*h*(Ts-Ta));
end Ex1_5;
//==========================================
