//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 1:Fundamental Concepts
//Example :1.9 page 12
//Topic:Concrete wall is exposed to air
//=======================================================================================================
model Ex1_9

//=====================
//Parameter section

parameter Real Ta(unit="degree celcius")=60"Temperature of one side of concrete exposed to air";
parameter Real Tb(unit="degree celcius")=20"Temperature on other side of concrete exposed to air";
parameter Real h1(unit="W/(m^2K)")=40"Convective heat transfer coefficients at 60 degree celcius";
parameter Real h2(unit="W/(m^2K)")=10"Convective heat transfer coefficients at 20 degree celcius";
parameter Real L(unit="m")=0.15"Thickness of the concrete";
parameter Real k(unit="W/mK")=0.8"Thermal conductivity";
parameter Real A(unit="m^2")=1"Surface area";

//=======================
//Variable section
//Let Q/A=F
Real F(unit="W/m^2")"Heat transfer per unit area";
Real T1(unit="degree celcius")"Surface temperature at one side";
Real T2(unit="degree celcius")"Surface temperature at other side";

//=======================
//Equation section
equation
F=(Ta-Tb)/((1/(h1*A))+(L/(k*A))+(1/(h2*A)));
T1=Ta-(F/h1);
T2=Tb+(F/h2);
end Ex1_9;
//==========================================================
