//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 10:Principles of Heat Exchangers
//Example :10.2 page 425
//Topic:Hot oil flows through counter flow heat exchanger
//===================================================================================

model Ex10_2
extends Modelica.Math;
extends Modelica.Constants;

//=================================
//parameter section

parameter Real m1(unit="kg/s")=0.7"Mass flow rate of hot oil";
parameter Real m2(unit="kg/s")=1.2"Mass flow rate of cold oil";
parameter Real Th1(unit="degree celcius")=200"Entering temperature of hot oil";
parameter Real Th2(unit="degree celcius")=70"Exit temperature of hot oil";
parameter Real Tc2(unit="degree celcius")=150"Exit temperature of cold oil";
parameter Real U(unit="W/m^2K")=650"Overall heat transfer coefficient";
parameter Real Cp1(unit="kJ/kgK")=2.09"Specific heat capacity of hot oil";
parameter Real Cp2(unit="kJ/kgK")=1.67"Specific heat capacity of cold oil";

//=================================
//Variable section

Real Tc1(unit="degree celcius")"Entering temperature of cold oil";
Real Q(unit="W")"Rate of heat transfer";
Real dT1(unit="degree celcius")"Temperature difference";
Real dT2(unit="degree celcius")"Temperature difference";
Real LMTD(unit="")"Log Mean Temperature Difference";
Real A(unit="m^2")"Area of heat exchanger for counterflow arrangement";

//=================================
//Equation section

equation

Tc1=Tc2-((Th1-Th2)*((m1*Cp1)/(m2*Cp2)));
Q=m1*Cp1*(Th1-Th2)*1e3;
dT1=Th1-Tc2;
dT2=Th2-Tc1;
LMTD=(dT2-dT1)/(log(dT2/dT1));
A=Q/(U*LMTD);


end Ex10_2;
