//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 10:Principles of Heat Exchangers
//Example :10.3 page 425
//Topic:Cross flow heat exchanger with both fluid unmixed
//===================================================================================

model Ex10_3
extends Modelica.Math;
extends Modelica.Constants;

//=================================
//parameter section

parameter Real m1(unit="kg/s")=1"Mass flow rate of water";
parameter Real m2(unit="kg/s")=3"Mass flow rate of hot oil";
parameter Real Th1(unit="degree celcius")=100"Entering temperature of hot oil";
parameter Real Tc1(unit="degree celcius")=50"Entering temperature of water";
parameter Real Tc2(unit="degree celcius")=90"Exit temperature of water";
parameter Real Cp1(unit="kJ/kgK")=4.18"Specific heat capacity of water";
parameter Real Cp2(unit="kJ/kgK")=1.9"Specific heat capacity of hot oil";
parameter Real A(unit="m^2")=20"Heat transfer area";

//=================================
//Variable section

Real Th2(unit="degree celcius")"Exit temperature of hot oil";
Real P(unit="")"Dimensionless parameter";
Real R(unit="")"Dimensionless parameter";
Real Q(unit="W")"Rate of heat transfer";
Real dT1(unit="degree celcius")"Temperature difference";
Real dT2(unit="degree celcius")"Temperature difference";
Real LMTD(unit="")"Log Mean Temperature Difference";
Real U(unit="kW/m^2K")"Overall heat transfer coefficient";

//=================================
//Equation section

equation

Th2=Th1-((Tc2-Tc1)*((m1*Cp1)/(m2*Cp2)));
dT1=Th1-Tc2;
dT2=Th2-Tc1;
LMTD=(dT2-dT1)/(log(dT2/dT1));
P=(Tc2-Tc1)/(Th1-Tc1);
R=(Th1-Th2)/(Tc2-Tc1);
//Using P and R from Figure 10.8(c) we get F=0.75
Q=m1*Cp1*(Tc2-Tc1);
U=Q/(A*0.75*LMTD);

end Ex10_3;
