//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 10:Principles of Heat Exchangers
//Example :10.6 page 433
//Topic:Water enters a counterflow heat exchanger
//===================================================================================

model Ex10_6
extends Modelica.Constants;
extends Modelica.Math;

//=================================
//parameter section

parameter Real mw(unit="kg/s")=0.8"Mass flow rate of water";
parameter Real Twi(unit="degree celcius")=35"Inlet temperature of water";
parameter Real Cpw(unit="kJ/kgK")=4.18"Specific heat of water";
parameter Real mo(unit="kg/s")=1.5"Mass flow rate of oil";
parameter Real Toi(unit="degree celcius")=120"Inlet temperature of oil";
parameter Real Cpo(unit="kJ/kgK")=1.88"Specific heat of oil";
parameter Real A(unit="m^2")=15"Area of the heat exchanger";
parameter Real U(unit="W/m^2K")=350"Overall heat transfer coefficient";

//=================================
//Variable section

Real Cmin(unit="kW/K")"Heat capacity of cold fluid";
Real Cmax(unit="kW/K")"Heat capacity of hot fluid";
Real Cr(unit="")"Capacity ratio";
Real Ec(unit="")"Effectiveness factor";
Real NTU(unit="")"Number of transfer units";
Real Q(unit="kW")"Heat transfer rate";

//=================================
//Equation section

equation

Cmax=mw*Cpw;
Cmin=mo*Cpo;
Cr=Cmin/Cmax;
NTU=(U*A)/(Cmin*1e3);
Ec=(1-(exp(-NTU*(1-Cr))))/(1-(Cr*exp(-NTU*(1-Cr))));
Q=Ec*Cmin*(Toi-Twi);

end Ex10_6;
