//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 10:Principles of Heat Exchangers
//Example :10.7 page 434
//Topic:Water enters a cross flow heat exchanger
//===================================================================================

model Ex10_7
extends Modelica.Constants;
extends Modelica.Math;

//=================================
//parameter section

parameter Real mw(unit="kg/s")=7"Mass flow rate of water";
parameter Real Twi(unit="degree celcius")=20"Inlet temperature of water";
parameter Real Cpw(unit="kJ/kgK")=4.18"Specific heat of water";
parameter Real ma(unit="kg/s")=10"Mass flow rate of air";
parameter Real Tai(unit="degree celcius")=125"Inlet temperature of air";
parameter Real Cpa(unit="kJ/kgK")=1.01"Specific heat of air";
parameter Real A(unit="m^2")=250"Area of the heat exchanger";
parameter Real U(unit="W/m^2K")=220"Overall heat transfer coefficient";

//=================================
//Variable section

Real Cmin(unit="kW/K")"Heat capacity of cold fluid";
Real Cmax(unit="kW/K")"Heat capacity of hot fluid";
Real Cr(unit="")"Capacity ratio";
Real Ec(unit="")"Effectiveness factor";
Real NTU(unit="")"Number of transfer units";
Real Q(unit="W")"Heat transfer rate";
Real Tao(unit="degree celcius")"Outlet temperature of air";

//=================================
//Equation section

equation

Cmax=mw*Cpw;
Cmin=ma*Cpa;
Cr=Cmin/Cmax;
NTU=(U*A)/(Cmin*1e3);
Ec=1-(exp(((NTU^0.22)/Cr)*(exp(-Cr*(NTU^0.78))-1)));
Q=Ec*Cmin*(Tai-Twi)*1e3;
Tao=Tai-(Q/(Cmin*1e3));

end Ex10_7;
