//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 10:Principles of Heat Exchangers
//Example :10.8 page 435
//Topic:A double pipe heat exchanger
//===================================================================================

package Ex10_8

//=========================================================================

model Ex10_8_a

//=================================
//parameter section

parameter Real mw(unit="kg/s")=2"Mass flow rate of water";
parameter Real Twi(unit="degree celcius")=25"Inlet temperature of water";
parameter Real Two(unit="degree celcius")=50"Outlet temperature of water";
parameter Real Cpw(unit="kJ/kgK")=4.18"Specific heat of water";
parameter Real Toi(unit="degree celcius")=100"Inlet temperature of oil";
parameter Real Cpo(unit="kJ/kgK")=1.88"Specific heat of oil";
parameter Real L(unit="m")=0.3"Length of heat exchanger";

//=================================
//Variable section

Real To1(unit="degree celciu")"Outlet temperature of oil";
Real mo1(unit="kg/s")"Mass flow rate of oil";

//=================================
//Equation section

equation

To1=Two;
mo1=(mw*Cpw*(Two-Twi))/(Cpo*(Toi-To1));

end Ex10_8_a;

//=========================================================================

model Ex10_8_b
extends Ex10_8_a;

//=================================
//Variable section

Real To2(unit="degree celciu")"Outlet temperature of oil";
Real mo2(unit="kg/s")"Mass flow rate of oil";
Real Cmin(unit="kW/K")"Heat capacity of cold fluid";
Real Cmax(unit="kW/K")"Heat capacity of hot fluid";
Real Ec(unit="")"Effectiveness factor";

//=================================
//Equation section

equation

To2=Twi;
mo2=(mw*Cpw*(Two-Twi))/(Cpo*(Toi-To2));
Cmin=mo2*Cpo;
Cmax=mw*Cpw;
Ec=(mo2*Cpo*(Toi-To2))/(mo2*Cpo*(Toi-Twi));

end Ex10_8_b;

//=========================================================================

end Ex10_8;
