//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 11:Radiation heat transfer
//Example :11.10 page 481
//Topic:Furnace as an equvilateral triangle
//===================================================================================

model Ex11_10
extends Modelica.Constants;

//=================================
//parameter section

parameter Real T1(unit="K")=1000"Temperature of hot wall";
parameter Real T2(unit="K")=350"Temperature of cold wall";
parameter Real E1(unit="")=0.75"Emissivity of hot wall";
parameter Real E2(unit="")=0.7"Emissivity of cold wall";
parameter Real F33(unit="")=0"View factor of base surface";
parameter Real F32(unit="")=0.5"view factor between surface 3 and 2";
parameter Real F11(unit="")=0"View factor of plane surface";

//=================================
//Variable section

Real F31(unit="")"view factor between surface 3 and 1";
Real F13(unit="")"view factor between surface 1 and 3";
Real F23(unit="")"view factor between surface 2 and 3";
Real F12(unit="")"view factor between surface 1 and 2";
Real R(unit="")"Equvivalent resistance";
Real Q(unit="kW/m^2")"Rate of heat transfer per unit area";

//=================================
//Equation section

equation

F31=F32;
F13=F31;
F23=F32;
F12=1-F11-F13;
R=((1-E1)/E1)+(1/(F12+(1/4)))+((1-E2)/E2);
Q=(sigma*((T1^4)-(T2^4))*1e-3)/R;

end Ex11_10;
