//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 11:Radiation heat transfer
//Example :11.4 page 466
//Topic:View factor for composite wall
//===================================================================================

model Ex11_4

//=================================
//parameter section

parameter Real F12_34(unit="")=0.14"View factor between surface 1,2 and 3,4";
parameter Real F12_3(unit="")=0.1"View factor between surface 1-2 and 3";
parameter Real F2_34(unit="")=0.24"View factor between surface 2 and 3,4";
parameter Real F23(unit="")=0.18"View factor between surface 2 and 3";
parameter Real L(unit="m")=4"Length of the surface";
parameter Real B1(unit="m")=3"Breadth of surface 1";
parameter Real B2(unit="m")=3"Breadth of surface 2";
parameter Real B3(unit="m")=2"Breadth of surface 3";
parameter Real B4(unit="m")=2"Breadth of surface 4";

//=================================
//Variable section

Real F1_24(unit="")"View factor between surface 1 and 2,4";
Real F24(unit="")"View factor between surface 2 and 4";
Real A1(unit="m^2")"Area of surface 1";
Real A2(unit="m^2")"Area of surface 2";
Real F14(unit="")"View factor between surface 1 and 4";

//=================================
//Equation section

equation

F1_24=F12_34-F12_3;
F24=F2_34-F23;
A1=B1*L;
A2=B2*L;
F1_24=(1/(A1+A2))*((A1*F14)+(A2*F24));


end Ex11_4;
