//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 11:Radiation heat transfer
//Example :11.6 page 468
//Topic:Two black body rectangles
//===================================================================================

package Ex11_6

//=========================================================================

model Ex11_6_a
extends Modelica.Constants;

//=================================
//parameter section

parameter Real L(unit="m")=3"Length of rectangular blackbody";
parameter Real B(unit="m")=1.5"Breadth of rectangular blackbody";
parameter Real T1(unit="degree celcius")=127"Temperature of surface 1";
parameter Real T2(unit="degree celcius")=327"Temperature of surface 2";
parameter Real F12(unit="")=0.11"View factor between surface 1 and 2";
parameter Real F11(unit="")=0"View factor of the flat base";

//=================================
//Variable section

Real Q12(unit="W")"Rate of heat transfer";

//=================================
//Equation section

equation

Q12=L*B*F12*sigma*(((T1+273)^4)-((T2+273)^4));

end Ex11_6_a;

//=========================================================================

model Ex11_6_b_i
extends Ex11_6_a;

//=================================
//Variable section

Real Q1(unit="W")"Heat transfer rate of surface 1";

//=================================
//Equation section

equation

Q1=L*B*sigma*(((T1+273)^4)-(((T2+273)^4)*F12));

end Ex11_6_b_i;

//=========================================================================

model Ex11_6_b_ii
extends Ex11_6_a;
extends Ex11_6_b_i;

//=================================
//parameter section

parameter Real Ts(unit="K")=300"Surrounding temperture";

//=================================
//Variable section

Real F1s(unit="")"view factor of surface 1 and surrounding";
Real Q11(unit="")"Rate of heat transfer when surrounding temperature is at 300K";

//=================================
//Equation section

equation

F1s=1-F12-F11;
Q11=L*B*sigma*(((T1+273)^4)-(((T2+273)^4)*F12)-(F1s*(Ts^4)));

end Ex11_6_b_ii;

//=========================================================================

end Ex11_6;
