//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 11:Radiation heat transfer
//Example :11.7 page 478
//Topic:Radiation energy exchange between nonblack surfaces
//===================================================================================

package Ex11_7

//=========================================================================

model Ex11_7_a
extends Modelica.Constants;

//=================================
//parameter section

parameter Real T1(unit="degree celcius")=200"Temperature of surface 1";
parameter Real T2(unit="degree celcius")=300"Temperature of surface 2";
parameter Real E1(unit="")=0.7"Emissivity of gray surface 1";
parameter Real E2(unit="")=0.7"Emissivity of gray surface 2";

//=================================
//Variable section 

Real Q1(unit="W/m^2")"Rate of heat transfer per unit area";

//=================================
//Equation section

equation

Q1=(sigma*(((T2+273.15)^4)-((T1+273.15)^4)))/((1/E1)+(1/E2)-1);

end Ex11_7_a;

//=========================================================================

model Ex11_7_b
extends Ex11_7_a;

//=================================
//Variable section

Real Q2(unit="W/m^2")"Rate of heat transfer per unit area";

//=================================
//Equation section

equation

Q2=sigma*(((T2+273.15)^4)-((T1+273.15)^4));

end Ex11_7_b;

//=========================================================================

end Ex11_7;

//==============================================================================
//Remarks
//Unit of Q is W/m^2 and not W
