//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 12:Principles of mass transfer
//Example :12.1 page 514
//Topic:Diffusion of vapour through a stationary gas:Concept of Stefan flow
//===================================================================================

package Ex12_1

//=========================================================================

model Ex12_1_a
extends Modelica.Constants;

//=================================
//parameter section

parameter Real Mh(unit="kg/s")=4"Mass flow rate of helium";
parameter Real Patm(unit="kPa")=101"Pressure in the pipeline ";
parameter Real d(unit="mm")=6"Inner diameter of the tube";
parameter Real L(unit="m")=20"Length of the tube";
parameter Real T(unit="degree celcius")=25"Temperature of helium and air";
parameter Real Dab(unit="m^2/s")=7.2e-5"Diffusion coefficient of helium";
parameter Real Mhe(unit="kg/kmol")=4"Molecular weight of helium";
parameter Real Ma(unit="kg/kmol")=29"Molecular weight of air";
parameter Real Yao(unit="")=1"Mole fraction of helium at bottom of tube";
parameter Real Yal(unit="")=0"Mole fraction of helium at top of tube";

//=================================
//Variable section

Real A(unit="m^2")"Flow area";
Real Cm(unit="")"Molar concentration of the mixture";
Real N(unit="kmol/s")"Flow rate by diffusion";
Real mhe(unit="kg/s")"Mass flow rate of helium lost to atmosphere";

//=================================
//Equation section

equation

A=(pi/4)*((d*1e-3)^2);
Cm=(Patm*1e3)/(8.314*(T+273)*1e3);
N=A*Cm*Dab*(Yao-Yal)/L;
mhe=N*Mhe;


end Ex12_1_a;

//=========================================================================

model Ex12_1_b
extends Ex12_1_a;

//=================================
//Variable section

Real ma(unit="kg/s")"Mass flow rate of air";

//=================================
//Equation section

equation

ma=N*Ma;

end Ex12_1_b;

//=========================================================================

end Ex12_1;
