//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 12:Principles of mass transfer
//Example :12.3 page 516
//Topic:Measurement of binary diffusion coefficient
//===================================================================================

model Ex12_3
extends Modelica.Constants;
extends Modelica.Math;

//=================================
//parameter section

parameter Real d(unit="mm")=35"Diameter of the tube";
parameter Real L(unit="m")=1500"Length of the tube";
parameter Real Lp(unit="mm")=500"Distance from water surface to open end";
parameter Real t(unit="days")=12"Number of operating days";
parameter Real To(unit="degree celcius")=25"Temperature of air";
parameter Real Pvap(unit="kPa")=3.17"Vapour pressure of water";//Found from steam table at To
parameter Real Yal(unit="")=0"Mole fraction of water at top";
parameter Real Patm(unit="kPa")=80"Atmospheric pressure";
parameter Real m(unit="kg")=1.2e-3"Amount of water evaporated";
parameter Real Mw(unit="kg/kmol")=18"Molecular wieght of water";

//=================================
//Variable section

Real Yao(unit="")"Mole fraction of water vapour at interface ";
Real Cm(unit="kmol/m^3")"Total molar concentration";
Real A(unit="m^2")"Cross-sectional area of the tube";
Real N(unit="kmol/s")"Molar flow rate of water vapour";
Real Dab(unit="m/s")"Diffusion coefficient of water vapour in air";

//=================================
//Equation section

equation

Yao=Pvap/Patm;
Cm=(Patm*1e3)/((8.314*1e3)*(To+273));
A=(pi/4)*((d*1e-3)^2);
N=m/(t*24*3600*Mw);
N=(Cm*Dab*A/(Lp*1e-3))*log((1-Yal)/(1-Yao));


end Ex12_3;
