//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.1 Page 42
//Topic:A plane wall of refrigerated wall
//================================================================================

package Ex2_1

//================================================================================

model Ex2_1_a

//=================================
//Parameter section

parameter Real A(unit = "m^2")=0.75"Surface area of the wall";
parameter Real ks(unit = "W/mK")=25"Thermal conductivity at outer surface";
parameter Real kp(unit = "W/mK")=0.05"Thermal conductivity of plywood";
parameter Real kG(unit = "W/mK")=0.01"Thermal conductivity of glass wool";
parameter Real Ti(unit = "degree celcius")=-15"Inner temperature";
parameter Real To(unit = "degree celcius")=24"Outer or Ambient temperatur";
parameter Real hi(unit = "W/mK")=12"Heat transfer coefficient at inner surface";
parameter Real ho(unit = "W/mK")=20"Heat transfer coefficient at outer surface";
parameter Real Ls(unit = "mm")=1.5"Steel sheet thickness";
parameter Real LG(unit = "mm")=20"Glass wood thickness";
parameter Real Lp(unit = "mm")=10"Plywood thickness";

//=================================
//Variable section

Real Ro(unit = "K/W")"Convective resistance at outer surface";
Real Rs(unit = "K/W")"Conduction resistance of steel sheet";
Real RG(unit = "K/W")"Conduction resistance of glass wool";
Real Rp(unit = "K/W")"Conduction resistance of plywood";
Real Ri(unit = "K/W")"Convective resistance at inner surface";

//=================================
//Equation section

equation
Ro=1/(ho*A);
Rs=(Ls/1000)/(A*ks);
RG=(LG/1000)/(A*kG);
Rp=(Lp/1000)/(A*kp);
Ri=1/(A*hi);

end Ex2_1_a;

//================================================================================

model Ex2_1_b
extends Ex2_1_a;

//=================================
//Variable section

Real Q(unit ="W")"Rate of heat flow";

//=================================
//Equation section

equation

Q=(To-Ti)/(Ro+Rs+RG+Rp+Ri);

end Ex2_1_b;

//================================================================================

model Ex2_1_c
extends Ex2_1_a;
extends Ex2_1_b;

//=================================
//Variable section

Real T1(unit = "degree celcius")"Temperature at outer surface of wall";
Real T2(unit = "degree celcius")"Temperature at interface between steel sheet and glass wool";
Real T3(unit = "degree celcius")"Temperature at interface between glass wood and plywood";
Real T4(unit = "degree celcius")"Temperature at inner surface of the wall";

//=================================
//Equation section

equation
T1=To-(Q*Ro);
T2=T1-(Q*Rs);
T3=T2-(Q*RG);
T4=T3-(Q*Rp);

end Ex2_1_c;


//================================================================================

end Ex2_1;
