//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.13 page 78
//Topic:Heat transfer from extended surface
//================================================================================

package Ex2_13

//================================================================================

model Ex2_13_a
extends Modelica.Math;
extends Modelica.Constants;

//====================================
//parameter section

parameter Real d(unit="mm")=10"Diameter of the copper rod";
parameter Real k(unit="w/mK")=370"Thermal conductivity of copper";
parameter Real To(unit="degree celcius")=20"Ambient temperature";
parameter Real h(unit="W/m^2K")=10"Heat transfer coefficient";
parameter Real Tb(unit="degree celcius")=120"Base temperature of rod";
parameter Real L1(unit="m")=0.02"Length to determine heat transfer";
parameter Real L2(unit="m")=0.04"Length to determine heat transfer";
parameter Real L3(unit="m")=0.08"Length to determine heat transfer";
parameter Real L4(unit="m")=0.2"Length to determine heat transfer";
parameter Real L5(unit="m")=0.4"Length to determine heat transfer";
parameter Real L6(unit="m")=0.8"Length to determine heat transfer";
parameter Real L7(unit="m")=1"Length to determine heat transfer";
parameter Real L8(unit="m")=10"Length to determine heat transfer";

//=======================================
//Variable section

Real P(unit="m")"Perimeter";
Real A(unit="m^2")"Area";
Real m(unit="m^-1")"";
Real F(unit="W/K")"";//Let F=(h*P*A*k)^0.5
Real R(unit="")"";//Let R=h/mk
Real Ob(unit="degree celcius")"Temperature difference";
Real Q1(unit="W")"Heat transfer rate at L1";
Real Q2(unit="W")"Heat transfer rate at L2";
Real Q3(unit="W")"Heat transfer rate at L3";
Real Q4(unit="W")"Heat transfer rate at L4";
Real Q5(unit="W")"Heat transfer rate at L5";
Real Q6(unit="W")"Heat transfer rate at L6";
Real Q7(unit="W")"Heat transfer rate at L7";
Real Q8(unit="W")"Heat transfer rate at L8";

//=======================================
//Equation section

equation

P=pi*(d/1000);
A=(pi/4)*((d/1000)^2);
m=sqrt((h*(P/A))/k);
F=sqrt(h*P*k*A);
R=(h/(m*k));
Ob=Tb-To;
Q1=F*Ob*((R+tanh(m*L1))/(1+(R*tanh(m*L1))));
Q2=F*Ob*((R+tanh(m*L2))/(1+(R*tanh(m*L2))));
Q3=F*Ob*((R+tanh(m*L3))/(1+(R*tanh(m*L3))));
Q4=F*Ob*((R+tanh(m*L4))/(1+(R*tanh(m*L4))));
Q5=F*Ob*((R+tanh(m*L5))/(1+(R*tanh(m*L5))));
Q6=F*Ob*((R+tanh(m*L6))/(1+(R*tanh(m*L6))));
Q7=F*Ob*((R+tanh(m*L7))/(1+(R*tanh(m*L7))));
Q8=F*Ob*((R+tanh(m*L8))/(1+(R*tanh(m*L8))));

end Ex2_13_a;

//================================================================================

model Ex2_13_b
extends Ex2_13_a;

//================================
//Variable section

Real Qinf(unit="W")"Heat transfer for infinitely long rod";

//================================
//Equation section

equation

Qinf=F*Ob;

end Ex2_13_b;

//================================================================================

end Ex2_13;
