//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.15 page 80
//Topic:Stack made of aluminium
//==============================================================================

model Ex2_15
extends Modelica.Math;

//=================================
//parameter section

parameter Real W(unit="mm")=300"Width of the stack";
parameter Real D(unit="mm")=100"Depth of the stack";
parameter Real L(unit="mm")=12"Length of the stack";
parameter Real N(unit="")=60"Number of fins";
parameter Real t(unit="mm")=1"Thickness of the stack";
parameter Real Tb(unit="K")=400"Maximum temperature allowed in outer surface";
parameter Real Tl(unit="K")=350"Maximum temperature allowed in inner surface";
parameter Real h(unit="W/m^2K")=150"Heat transfer coefficient";
parameter Real Ta(unit="K")=300"Ambient temperature";
parameter Real ka(unit="W/mK")=230"Thermal conductivity of the stack(Aluminium)";

//=================================
//Variable section

Real M(unit="")"";
Real m(unit="")"";
Real P(unit="m")"Perimeter of the plate";
Real A(unit="m")"Area of the plate";
Real Ob(unit="K")"Temperature difference";
Real Ol(unit="K")"Temperature difference";
Real Q1(unit="W")"Heat loss from fins";
Real Q2(unit="W")"Heat loss from unfinned portion of the plate";
Real Q3(unit="W")"Heat loss from outer surface of the plate";
Real Q(unit="W")"Heat loss the plate at 400K";

//===================================
//Equation section

equation
P=(2*(D+t)/1000);
A=(t/1000)*(D/1000);
M=sqrt(h*P*A*ka);
m=sqrt((h*P)/(ka*A));
Ob=Tb-Ta;
Ol=Tl-Ta;
Q1=N*M*((Ob*cosh(m*L/1000))-Ol)/(sinh(m*L/1000));
Q2=((D/1000)*(W/1000)-(Ol*A))*Ob*h;
Q3=(D/1000)*(W/1000)*h*Ob;
Q=Q1+Q2+Q3;

end Ex2_15;
