//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.4 page 45
//Topic:In a manufacturing process
//================================================================================

package Ex2_4

//================================================================================

model Ex2_4_a

//=================================
//Parameter section

parameter Real Lf(unit = "mm")=0.25"Film thickness";
parameter Real Ls(unit = "mm")=1.5"Substrate thickness";
parameter Real Ta(unit = "degree celcius")=20"Ambient temperature";
parameter Real To(unit = "degree celcius")=60"Temperature at interface";
parameter Real T1(unit = "degree celcius")=30"Temperature at surface of substrate";
parameter Real h(unit = "W/m^2K")=25"Heat transfer coefficient of the substrate";
parameter Real kf(unit = "W/mK")=0.025"Thermal conductivity of the film";
parameter Real ks(unit = "W/mK")=0.05"Thermal conductivity of the substrate";

//=================================
//Variable section

Real qo(unit = "W/m^2")"Heat flux at the interface";
Real qf(unit = "W/m^2")"Heat transfer per unit area through film";
Real qs(unit = "W/m^2")"Heat transfer per unit area through substrate";

//=================================
//Equation section

equation
qf=(To-Ta)/((1/h)+((Lf/1000)/kf));
qs=(To-T1)/((Ls/1000)/ks);
qo=qf+qs;

end Ex2_4_a;

//================================================================================

model Ex2_4_b
extends Ex2_4_a;

//=================================
//Variable section
Real q0(unit = "W/m^2")"Heat flux at the interface";
Real q1(unit = "W/m^2")"Rate of heat transfer through the film and substrate";
Real q2(unit = "W/m^2")"Rate of convective heat transfer from film to air";
Real T2(unit = "degree celcius")"Temperature at the top surface of the film";

//=================================
//Equation section

equation
q1=(To-T1)/((Ls/1000)/ks);
T2=(q1*((Lf/1000)/kf))+To;
q2=h*(T2-Ta);
q0=q1+q2;

end Ex2_4_b;

//================================================================================

end Ex2_4;
