//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.6 page 49
//Topic:Thick plate with uniform heat generation
//================================================================================

package Ex2_6

//================================================================================

model Ex2_6_b
extends Modelica.Constants;

//============================
//parameter section

parameter Real qG(unit = "MW/m^3")=80"Heat generated at the plate";
parameter Real T1(unit = "degree celcius")=160"Temperature at x=0";
parameter Real T2(unit = "degree celcius")=120"Temperature at x=0.02";
parameter Real k(unit = "W/mK")=200"Thermal conductivity of the plate";
parameter Real L(unit = "mm")=20"Thickness of the plate";
parameter Real x(unit ="m")=0.005"Location of the maximum temperature";
parameter Real x1(unit = "m")=0"Location at left place";
parameter Real x2(unit = "m")=0.02"Location at right place";
parameter Real x3(unit = "m")=0.01"Location at the place centre";
//======================
//Variable section

Real Tmax(unit = "degree celcius")"Maximum Temperature";

//======================
//Equation section
//(dT/dx)=(2*10^3)-(4*10^5)*x
//q=-k*(dT/dx) at x=0,0.020.01
equation
Tmax=T1+(2*(10^3)*x)-(2*(10^5)*(x^2));

end Ex2_6_b;

//================================================================================

model Ex2_6_ci
extends Ex2_6_b;

//==============================
//Variable section
Real dTo(unit = "")"Temperature gradient at x=0";
Real qo(unit = "MW/m^2")"Rate of heat transfer per unit area at x=0";

//==============================
//Equation section

equation
dTo=(2*(10^3))-(4*(10^5)*x1);
qo=(-k)*dTo/(10^6);

end Ex2_6_ci;

//================================================================================

model Ex2_6_cii
extends Ex2_6_b;

//==============================
//Variable section
Real dT1(unit = "")"Temperature gradient at x=0.02";
Real q1(unit = "MW/m^2")"Rate of heat transfer per unit area at x=0.02";

//==============================
//Equation section

equation
dT1=(2*(10^3))-(4*(10^5)*x2);
q1=(-k)*dT1/(10^6);

end Ex2_6_cii;

//================================================================================

model Ex2_6_ciii
extends Ex2_6_b;

//==============================
//Variable section
Real dT2(unit = "")"Temperature gradient at x=0.01";
Real q2(unit = "MW/m^2")"Rate of heat transfer per unit area at x=0.01";

//==============================
//Equation section

equation
dT2=(2*(10^3))-(4*(10^5)*x3);
q2=(-k)*dT2/(10^6);

end Ex2_6_ciii;

//================================================================================

end Ex2_6;
