//Textbook: Introduction to heat transfer 
//Author: S.K.Som
//Publisher: PHI Learning Pvt. Ltd., New Delhi
//2008

//Chapter 2: One dimensional Steady state Heat Conduction 
//Example : 2.9 page 59
//Topic:A thin walled copper tube
//================================================================================

package Ex2_9

//================================================================================

model Ex2_9_a
extends Modelica.Constants;

//========================
//parameter section

parameter Real r1(unit = "m")=0.01"Radius of copper tube";
parameter Real T1(unit = "K")=400"Temperature of steam carried in copper tube";
parameter Real Ta(unit = "K")=300"Surrounding air temperature";
parameter Real k(unit = "W/mK")=0.07"Thermal conductivity of magnesia insulation";
parameter Real h(unit = "W/m^2K")=4"Convective heat transfer coefficient";
parameter Real L(unit = "m")=1"Length of the tube";
parameter Real ri1(unit = "m")=0.002"Thickness of insulation";
parameter Real ri2(unit = "m")=0.05"Thickness of insulation";

//=========================
//Variable section

Real rc(unit = "m")"critical thickness of insulation";

//=========================
//Equation section

equation
rc=k/h;

end Ex2_9_a;

//================================================================================

model Ex2_9_bi
extends Ex2_9_a;

//==============================
//Variable section
Real r21(unit = "m")"Outer radius with 0.002 thickness";
Real Q1(unit = "W/m")"Rate of heat transfer per unit length";

//==============================
//Equation section

equation
r21=r1+ri1;
Q1=(T1-Ta)/(((log(r21/r1))/(2*pi*k))+(1/(2*pi*r21*h)));

end Ex2_9_bi;

//================================================================================

model Ex2_9_bii
extends Ex2_9_a;

//==============================
//Variable section
Real r2c(unit = "m")"Outer radius with critical thickness";
Real Qc(unit = "W/m")"Rate of heat transfer per unit length";

//==============================
//Equation section

equation
r2c=rc;
Qc=(T1-Ta)/(((log(r2c/r1))/(2*pi*k))+(1/(2*pi*r2c*h)));

end Ex2_9_bii;

//================================================================================

model Ex2_9_biii
extends Ex2_9_a;

//==============================
//Variable section
Real r22(unit = "m")"Outer radius with 0.05 thickness";
Real Q2(unit = "W/m")"Rate of heat transfer per unit length";

//==============================
//Equation section

equation
r22=r1+ri2;
Q2=(T1-Ta)/(((log(r22/r1))/(2*pi*k))+(1/(2*pi*r22*h)));

end Ex2_9_biii;

//================================================================================

end Ex2_9;
